/* Adobe.TestHandleTeask.js */

define([
	"lodash", "src/math/mathUtils", 
	"src/math/vec2", "src/math/mat3",
	"lib/tasks"
	], 
function(
	lodash, mathUtils, 
	vec2, mat3,
	tasks
) {
	"use strict";

	return {
		about                   : "Tests Matrix Dofs.",
		description             : "Internal testing behavior.",
		uiName                  : "Test Matrix Dofs",
		defaultArmedForRecordOn : false,
			
		hideInBehaviorList      : true,

		defineParams : function () {
			return [
				{
					id: "moveTargets", type: "handle", uiName: "Move with Transform ",
					dephault: { match: "//Adobe.Dragger.Draggable" }
				},
				{
					id: "fixTargets", type: "handle", uiName: "Fix with Identity",
					dephault: { match: "//Adobe.HandleFixer.Fixed" }
				},
				{id:"warpReferenceFrame", type:"checkbox", uiName:"Using warp reference frame?", dephault:false},
				{id:"positionX", type:"slider", uiName:"$$$/private/animal/Behavior/TestHandleTask/Param/PositionX=Position X",	precision:1, dephault:0},
				{id:"positionY", type:"slider", uiName:"$$$/private/animal/Behavior/TestHandleTask/Param/PositionY=Position Y",	precision:1, dephault:0},
				{id:"uniformScale", type:"slider", uiName:"$$$/private/animal/Behavior/TestHandleTask/Param/Scale=Scale",		precision:1, uiUnits:"%", dephault:100},
				{id:"rotation", type:"angle", uiName:"$$$/private/animal/Behavior/TestHandleTask/Param/Rotation=Rotation", precision:0, dephault:0}
			];
		},
		
		onCreateBackStageBehavior : function (/* self */) {
			return {
				order : 0.0,
				importance : 1.0
			};
		},
		
		onCreateStageBehavior : function (/*self, args */) {
		},
		
		onAnimate : function (self, args) { 
			var position = vec2([args.getParam("positionX"), args.getParam("positionY")]),
				uniformScale = args.getParam("uniformScale") * 0.01,
				angle = args.getParam("rotation"),
				moveTargets = args.getParam("moveTargets"),
				fixTargets = args.getParam("fixTargets");


			moveTargets.forEach(function (h) {
				tasks.handle.setFrame(h, 
					mat3.affine(position, [ uniformScale, uniformScale], [ 0 ], [ mathUtils.rad(angle) ]), 
					tasks.dofs.type.kAffine);
			});

			fixTargets.forEach(function (h) {
				tasks.handle.setFrame(h, mat3.identity(), tasks.dofs.type.kTranslation);
			});
		}
			
	}; // end of object being returned
});
